package com.xebialabs.deployit.core.config.hash

import java.io.File

import ai.digital.deploy.core.common.XldServerPaths._
import com.typesafe.config.ConfigFactory.parseResources
import com.typesafe.config.{Config, ConfigParseOptions, ConfigSyntax}
import com.xebialabs.deployit.engine.tasker.distribution.versioning.ConfigurationHashProvider
import com.xebialabs.deployit.repository.ConfigurationVersionRepository
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class ConfigurationHashConfiguration {

  @Bean(initMethod = "init")
  def configurationHashProvider(configurationVersionRepository: ConfigurationVersionRepository): ConfigurationHashProvider = {
    ConfigurationHashConfiguration.hashDefaults(DatabaseConfigurationHashProvider(configurationVersionRepository))
  }

}

object ConfigurationHashConfiguration {
  def hashDefaults(f: (Seq[File], Seq[Config], Seq[String], Set[String]) => ConfigurationHashProvider): ConfigurationHashProvider =
    f(
      Seq(XL_HOTFIX_PLUGINS_FOLDER, XL_PLUGINS_LOCAL_FOLDER, XL_PLUGINS_OFFICIAL_FOLDER, EXT_FOLDER),
      Seq(parseResources(DEFAULT_CONFIGURATION_FILE.getPath, ConfigParseOptions.defaults.setSyntax(ConfigSyntax.PROPERTIES))),
      defaultWhitelistedPaths,
      defaultBlacklistedConfigurationKeys
    )
}
