package com.xebialabs.deployit.core.ordering

import java.util.concurrent.atomic.AtomicReference

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class VersionOrdering @Autowired()(configurationItemIdComparator: ConfigurationItemIdComparator) {
  VersionOrdering.comparator.set(configurationItemIdComparator)
}

object VersionOrdering extends Ordering[String] {
  val EMPTY_LAST_VERSION: String = ""
  val comparator = new AtomicReference[ConfigurationItemIdComparator]()

  def compare(a: String, b: String): Int = comparator.get.compare(get(a), get(b))

  def get(s: String): String = if (s == null || s.trim.isEmpty) "0" else s
}
