package com.xebialabs.deployit.core.ordering

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.{Comparator, List => JList}
import scala.jdk.CollectionConverters._

@Component
class ConfigurationItemIdComparator @Autowired()(comparators: JList[PartialComparator[String]]) extends Comparator[ConfigurationItemId] {

  override def compare(o1: ConfigurationItemId, o2: ConfigurationItemId): Int = compare(getName(o1), getName(o2))

  def compare(name1: String, name2: String): Int =
    comparators
      .asScala
      .view
      .map(_.compare(name1, name2))
      .collectFirst {
        case res if res.processedLeft && res.processedRight => res.processResult
        case res if res.processedLeft => -1
        case res if res.processedRight => 1
      }
      .getOrElse(-1)

  def getName(o2: ConfigurationItemId): String = {
    val id = o2.getId
    val indexOfLastSlash = id.lastIndexOf('/')
    if (indexOfLastSlash > -1) id.substring(indexOfLastSlash + 1) else id
  }
}
