package liquibase.ext;

import liquibase.database.Database;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.BlobType;
import liquibase.datatype.core.ClobType;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateTableGenerator;
import liquibase.statement.core.CreateTableStatement;
import liquibase.structure.DatabaseObject;

public class CreateTableGeneratorOracle extends CreateTableGenerator {

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public boolean supports(final CreateTableStatement statement, final Database database) {
        return database.getShortName().equals("oracle");
    }

    @Override
    public Sql[] generateSql(final CreateTableStatement statement, final Database database, final SqlGeneratorChain sqlGeneratorChain) {
        final Sql[] sqls = super.generateSql(statement, database, sqlGeneratorChain);
        final StringBuilder sb = new StringBuilder(sqls[0].toSql());
        statement.getColumns().stream().filter(name -> isLob(statement.getColumnTypes().get(name))).forEach(name -> {
            final String columnName = database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), name);
            sb.append(String.format(" LOB(%s) STORE AS SECUREFILE", columnName));
        });
        sqls[0] = cloneSql(sb.toString(), sqls[0]);
        return sqls;
    }

    private boolean isLob(final LiquibaseDataType dataType) {
        return dataType instanceof ClobType || dataType instanceof BlobType;
    }

    private UnparsedSql cloneSql(String string, Sql sql) {
        return new UnparsedSql(string, sql.getEndDelimiter(), sql.getAffectedDatabaseObjects().toArray(new DatabaseObject[0]));
    }
}