package com.xebialabs.deployit.core.config

import com.xebialabs.deployit.repository.RepositoryMetadataService
import com.xebialabs.deployit.service.externalproperties.ExternalPropertiesResolverImpl
import com.xebialabs.deployit.service.gc.GarbageCollectionService
import com.xebialabs.license.License
import com.xebialabs.license.service._
import com.xebialabs.xlplatform.config.ProductConfiguration
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration, Import}

@Configuration
@Import(Array(classOf[ExternalPropertiesResolverImpl]))
class XlPlatformConfiguration {

  @Bean
  @Autowired
  def licenseService(repositoryMetadataService: RepositoryMetadataService,
                     licenseCiCounterFactory: LicenseCiCounterFactory,
                     xldProductConfiguration: ProductConfiguration): LicenseService = {
    val licenseService = new LicenseServiceFactory(
      repositoryMetadataService,
      licenseCiCounterFactory,
      xldProductConfiguration.configuration,
      "conf/deployit-license.lic",
      License.PRODUCT_XL_DEPLOY).createLicenseService()
    licenseService.initialize(licenseCiCounterFactory)
    licenseService
  }

  @Bean
  def garbageCollectionService: GarbageCollectionService = () => {}

}
