package com.xebialabs.deployit.core.config

import ai.digital.configuration.central.deploy.TaskerSystemProperties
import com.sksamuel.elastic4s.http.JavaClient
import com.sksamuel.elastic4s.{ElasticClient, ElasticProperties}
import com.xebialabs.deployit.engine.tasker.log.elastic.{ElasticLogRetrieverHelper, ElasticStepLogFactory, ElasticStepLogRetriever}
import com.xebialabs.deployit.engine.tasker.log.{DefaultStepLogFactory, DefaultStepLogRetriever, StepLogFactory, StepLogRetriever}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class StepLogConfiguration {

  @Autowired
  var taskerSystemProperties: TaskerSystemProperties = _

  lazy val client: ElasticClient = ElasticClient(JavaClient(ElasticProperties(taskerSystemProperties.logger.elastic.uri)))

  @Bean
  def stepLogRetriever: StepLogRetriever =
    if (!isEmpty(taskerSystemProperties.logger.elastic.uri))
      new ElasticStepLogRetriever(new ElasticLogRetrieverHelper(client, taskerSystemProperties.logger.elastic.index))
    else new DefaultStepLogRetriever


  @Bean
  def stepLogFactory: StepLogFactory =
    if (!isEmpty(taskerSystemProperties.logger.elastic.uri))
      new ElasticStepLogFactory(client, taskerSystemProperties.logger.elastic.index) else new DefaultStepLogFactory

  def isEmpty(value: String): Boolean = value == null || value.isEmpty
}
