package com.xebialabs.deployit.core.config

import com.fasterxml.jackson.annotation.JsonInclude.Include
import com.fasterxml.jackson.databind.module.SimpleModule
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter
import com.fasterxml.jackson.databind.ser.std.StringSerializer
import com.fasterxml.jackson.databind.{JavaType, ObjectMapper, PropertyName, SerializationFeature}
import com.xebialabs.deployit.core.serializers.{ConfigurationItemDeserializer, ConfigurationItemObjectIdGenerator, ConfigurationItemSerializer}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.util.PasswordEncrypter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class JacksonConfiguration {

  @Bean
  @Autowired
  def historyMapper(passwordEncrypter: PasswordEncrypter): ObjectMapper = {
    val m = new ObjectMapper
    m.setSerializationInclusion(Include.NON_NULL)
    m.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)

    val objectIdWriter = ObjectIdWriter.construct(
      m.getTypeFactory.constructSimpleType(classOf[String], new Array[JavaType](0)),
      new PropertyName("id"),
      ConfigurationItemObjectIdGenerator, false
    ).withSerializer(new StringSerializer)

    val historyModule = new SimpleModule("xld.history")
    historyModule.addSerializer(classOf[ConfigurationItem], new ConfigurationItemSerializer(passwordEncrypter, objectIdWriter))
    historyModule.addDeserializer(classOf[ConfigurationItem], new ConfigurationItemDeserializer(passwordEncrypter, objectIdWriter))
    m.registerModule(historyModule)
    m
  }
}
