package com.xebialabs.deployit.configuration

import com.typesafe.config.{Config, ConfigFactory, ConfigParseOptions, ConfigSyntax}
import com.xebialabs.deployit.core.config.SpringConfigurationCollector
import com.xebialabs.deployit.hocon.HoconPropertySourceLoader.WITH_DEFAULTS_NAME_SUFFIX
import com.xebialabs.deployit.tasksystem.ConfigLoading
import com.xebialabs.xlplatform.config.ProductConfiguration
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class XldProductConfiguration(@Autowired springConfigurationCollector: SpringConfigurationCollector,
                              @Autowired(required = false) customProductConfiguration: CustomProductConfiguration) extends ProductConfiguration {

  override val configuration: Config = {

    val includeConfDefaults: String => Boolean = name => name.contains("xl-deploy.conf") && name.endsWith(WITH_DEFAULTS_NAME_SUFFIX)
    val excludeConfDefaults: String => Boolean = name => !includeConfDefaults(name)

    val (properties, map) = springConfigurationCollector.environmentProperties(excludeConfDefaults)
    val (defaultProperties, defaultMap) = springConfigurationCollector.environmentProperties(includeConfDefaults)

    val mapConfig = ConfigFactory.parseMap(map, "spring-configuration")
    val propertiesConfig = ConfigFactory.parseProperties(
      properties,
      ConfigParseOptions.defaults()
        .setSyntax(ConfigSyntax.PROPERTIES)
        .setOriginDescription("spring-configuration-properties")
    )

    val defaultMapConfig = ConfigFactory.parseMap(defaultMap, "hocon-default-configuration")
    val defaultPropertiesConfig = ConfigFactory.parseProperties(
      defaultProperties,
      ConfigParseOptions.defaults()
        .setSyntax(ConfigSyntax.PROPERTIES)
        .setOriginDescription("hocon-default-properties")
    )

    var config = propertiesConfig.withFallback(mapConfig)
    val defaultConfig = defaultPropertiesConfig.withFallback(defaultMapConfig)

    if (config.hasPath("deploy.artifact")) {
      config = config.withValue("xl.artifact", config.getValue("deploy.artifact")).withoutPath("deploy.artifact")
    }

    if (config.hasPath("deploy.server.license")) {
      config = config.withValue("xl.license", config.getValue("deploy.server.license")).withoutPath("deploy.server.license")
    }

    ConfigLoading.loadConfig(
      Option(customProductConfiguration)
        .map(_.configuration.withFallback(config.withoutPath("deploy.server.hostname")))
        .getOrElse(config)
    ).withFallback(defaultConfig)
  }
}
