package com.xebialabs.deployit.converter

import ai.digital.configuration.central.deploy.converter.HoconDurationConverter
import akka.util.Timeout
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding
import org.springframework.core.convert.converter.Converter
import org.springframework.stereotype.Component

object AkkaTimeoutConverter {

  def convert(source: String): Timeout =
    Option(source).map { source =>
      Timeout(HoconDurationConverter.convert(source))
    }.orNull
}

@Component
@ConfigurationPropertiesBinding
class AkkaTimeoutConverter extends Converter[String, Timeout] {
  def convert(source: String): Timeout = Timeout(HoconDurationConverter.convert(source))
}


