package com.xebialabs.deployit.core.config.db

import com.google.common.base.Strings
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.SpringApplication
import org.springframework.context.ApplicationContext
import org.springframework.stereotype.Component

import javax.annotation.PostConstruct

@Component
class MainDatabaseConfigurationValidator extends Logging {

  @Autowired(required = true)
  var mainDatabase: MainDatabase = _

  @Autowired
  var context: ApplicationContext = _

  @PostConstruct
  def validate(): Unit = {
    val repositoryDbDriverMissing = Strings.isNullOrEmpty(mainDatabase.database.dbDriverClassname)
    val repositoryDbUrlMissing = Strings.isNullOrEmpty(mainDatabase.database.dbUrl)
    val repositoryDbUsernameMissing = mainDatabase.database.dbUsername == null
    val repositoryDbPasswordMissing = mainDatabase.database.dbPassword == null

    if (repositoryDbDriverMissing || repositoryDbUrlMissing || repositoryDbUsernameMissing || repositoryDbPasswordMissing) {
      logger.error("Database is not configured properly in deploy-repository.yaml")
      if (repositoryDbDriverMissing) logger.error("Property `xl.repository.database.db-driver-classname` not found, please configure it in your deploy-repository.yaml.")
      if (repositoryDbUrlMissing) logger.error("Property `xl.repository.database.db-url` not found, please configure it in your deploy-repository.yaml")
      if (repositoryDbUsernameMissing) logger.error("Property `xl.repository.database.db-username` not found, please configure it in your deploy-repository.yaml.")
      if (repositoryDbPasswordMissing) logger.error("Property `xl.repository.database.db-password` not found, please configure it in your deploy-repository.yaml.")
      System.exit(SpringApplication.exit(context, () => 1))
    }
  }

}
