package com.xebialabs.deployit.core.config.db

import java.beans.BeanProperty
import java.io.File

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.xebialabs.deployit.artifact.resolution.InternalArtifactResolver
import com.xebialabs.deployit.repository.sql.artifacts.{ArtifactDataRepository, ArtifactDataRepositoryFactory}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.context.ApplicationContext
import org.springframework.context.annotation.{Bean, Configuration, Primary}

/**
  * Main repository configuration.
  * It can be used as a single repository for the entire application too.
  * Right now you can configure to keep reporting in a separate schema or even separate database.
  */
@Configuration
@ConfigurationProperties(prefix = "xl.repository")
@JsonIgnoreProperties(ignoreUnknown = true)
class MainDatabase extends DatabaseAware {

  /**
    * Configures the behaviour of artifacts.
    *
    * Where to store it and permission limitations.
    */
  @BeanProperty
  var artifacts: Artifacts = new Artifacts()

  /**
    * Database configuration through the hikari.
    */
  @BeanProperty
  var database: DatabaseProperties = new DatabaseProperties()

  @Bean
  def artifactRepositoryRoot: File = new File(artifacts.root)

  @Bean
  def artifactResolver: InternalArtifactResolver.type = InternalArtifactResolver.getInstance()

  @Bean
  @Primary
  @Autowired
  def artifactRepository(applicationContext: ApplicationContext): ArtifactDataRepository = {
    val configuredArtifactDataRepoName = s"${artifacts.`type`}${classOf[ArtifactDataRepository].getSimpleName}"
    val repos = applicationContext.getBeansOfType(classOf[ArtifactDataRepository])
    ArtifactDataRepositoryFactory.createArtifactDataRepository(configuredArtifactDataRepoName, repos, artifacts.allowMove)
  }
}
