package com.xebialabs.deployit.core.config.db

import com.fasterxml.jackson.annotation.JsonProperty

import scala.beans.BeanProperty

class Artifacts {

  /**
    * Should artifacts -found in other (not configured) storage options- be moved to the configured storage?
    * If the system detects artifact data in the database, but the storage type is configured as "file" or vice versa, this
    * setting is required to be true and the system will move the artifacts from the database/file storage to the
    * file/database storage.
    *
    * Default: false
    */
  @BeanProperty
  @JsonProperty("allow-move")
  var allowMove: Boolean = false

  /**
    * Location for artifact storage on file system.
    * Only active when type = "file".
    *
    * Default: artifacts
    */
  @BeanProperty
  var root: String = "artifacts"

  /**
    * Type of artifact storage to use. Valid values are:
    * - "file": use the specified file system location for storing artifacts.
    * - "db": use the database for storing artifacts.
    *
    * Default: file
    */
  @BeanProperty
  var `type`: String = "file"
}
