package com.xebialabs.deployit.core.config

import com.fasterxml.jackson.annotation.JsonProperty
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.stereotype.Component

import java.util.{ArrayList => JArrayList}
import scala.beans.BeanProperty

/**
  * This configuration is used to validate the password strength when new user is created.
  */
@Component("secretComplexityConfiguration")
@ConfigurationProperties(prefix = "deploy.secret-complexity")
class SecretComplexityProperties {

  /**
    * The Regex validation for password strength.
    * Default to
    * {{{
    *     - ".{8,}$"
    *     - "Must have at least 8 characters"
    *     - "(?=.*\\d)"
    *     - "Must contain at least 1 digit"
    *     - "(?=.*[A-Z])"
    *     - "Must contain at least 1 uppercase letter"
    *     - "(?=.*[a-z])"
    *     - "Must contain at least 1 lowercase letter"
    * }}}
    */
  @BeanProperty
  @JsonProperty("regex-validations")
  var regexValidations = new JArrayList[String]

}
