package com.xebialabs.deployit.core.config

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.context.annotation.Configuration

import java.util.{HashMap => JHasMap}
import scala.beans.BeanProperty

@Configuration
@ConfigurationProperties(prefix = "xl.xldeploy.placeholders")
class ArchiveExtensionMappingsProperties {

  /**
    *
    * Configuration which stream to use for which extension.
    *
    * Functionality is built on top of "Apache Commons Compress" library.
    *
    * Zip -> ZipFileArchiveStreamer
    * Jar -> JarFileArchiveStreamer
    * Tar, tar.gz, tar.bz2 -> ArchiveStreamer
    *
    * Default value is:
    * zip -> "zip",
    * jar-> "jar",
    * tar-> "tar",
    * "tar.gz" -> "tar.gz",
    * "tar.bz2"-> "tar.bz2",
    * # JEE archives
    * ear -> "jar",
    * war -> "jar",
    * # JBoss archives
    * sar -> "jar",
    * rar -> "jar",
    * aop -> "jar",
    * har -> "jar",
    * aar -> "zip"
    */
  @BeanProperty
  var archiveExtensions = new JHasMap[String, String]()
}
