package com.xebialabs.xlplatform.scheduler

import org.springframework.scheduling.support.CronExpression

import java.time.LocalDateTime


trait Trigger {
  def nextExecution(date: LocalDateTime): LocalDateTime
}

case class CronTrigger(expression: String) extends Trigger {
  val sequenceGenerator = CronExpression.parse(expression)

  override def nextExecution(date: LocalDateTime): LocalDateTime = {
    sequenceGenerator.next(date)
  }
}