package com.xebialabs.xlplatform.scheduler;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import org.springframework.scheduling.support.CronExpression;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.LocalDateTime;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = CronPattern.Validator.class, type = "cronPattern")
@ApplicableTo(PropertyKind.STRING)
@Target(ElementType.FIELD)
public @interface CronPattern {
    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        @Override
        public void validate(String value, ValidationContext context) {
            if (value == null || value.isEmpty()) {
                return;
            }
            try {
                CronExpression.parse(value).next(LocalDateTime.now());
            } catch (IllegalArgumentException e) {
                context.error(e.getMessage());
            }
        }

    }
}
