package com.xebialabs.xlplatform.scheduler.spring;

import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDirFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class ServiceHolder {

    private static final AtomicReference<RepositoryService> repositoryService = new AtomicReference<>();
    private static final AtomicReference<TaskExecutionEngine> taskExecutionEngine = new AtomicReference<>();
    private static final AtomicReference<WorkDirFactory> workDirFactory = new AtomicReference<>();

    @Autowired
    public ServiceHolder(RepositoryService repositoryService, WorkDirFactory workDirFactory) {
        ServiceHolder.repositoryService.set(repositoryService);
        ServiceHolder.workDirFactory.set(workDirFactory);
    }

    public static void setTaskExecutionEngine(TaskExecutionEngine engine) {
        ServiceHolder.taskExecutionEngine.set(engine);
    }

    public static RepositoryService getRepositoryService() {
        return ServiceHolder.repositoryService.get();
    }

    public static TaskExecutionEngine getTaskExecutionEngine() {
        return ServiceHolder.taskExecutionEngine.get();
    }

    public static WorkDirFactory getWorkDirFactory() {
        return ServiceHolder.workDirFactory.get();
    }

}
