package com.xebialabs.xlplatform.scheduler

import java.util.Date

import org.springframework.scheduling.support.CronSequenceGenerator

trait Trigger {
  def nextExecution(date: Date): Date
}

case class CronTrigger(expression: String) extends Trigger {
  val sequenceGenerator = new CronSequenceGenerator(expression)

  override def nextExecution(date: Date): Date = {
    sequenceGenerator.next(date)
  }
}