package com.xebialabs.xlplatform.scheduler.ci

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot._
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.scheduler.{CronPattern, CronTrigger, Trigger}

import scala.beans.BeanProperty

@Metadata(virtual = true, root = CONFIGURATION, description = "Base administration job scheduled using a CRON expression trigger")
class CronJob extends ScheduledJob {
  @BeanProperty
  @CronPattern
  @Property(label = "Crontab schedule", required=true, description = "The pattern is a list of six single space-separated fields: representing second, minute, hour, day, month, weekday. Month and weekday names can be given as the first three letters of the English names." +
    "Example patterns: '0 0 * * * *' = the top of every hour of every day, '0 0 14 * * SAT,SUN' = 14 o'clock on each weekend day, '0 0 9-17 * * MON-FRI' = on the hour nine-to-five weekdays, '0 0 0 1 * *' = every 1st of month at midnight.")
  var schedule: String = _

  override def getTrigger(): Trigger = new CronTrigger(schedule)
}


