package com.xebialabs.xlplatform.scheduler.ci

import java.util.{Map => JMap, HashMap => JHashMap}

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}

import scala.beans.BeanProperty


@Metadata(root = CONFIGURATION, description = "Scheduled control task invocation job")
class ControlTaskJob extends CronJob with ControlTaskInvokable {
  @BeanProperty
  @Property(label = "Configuration item Id", required = true, description = "Identifier of the target configuration item on which to invoke the control task")
  var configurationItemId: String = _

  @BeanProperty
  @Property(label = "Control task name", required = true, description = "Name of the control task to invoke as specified in the synthetic.xml or the @ControlTask annotation")
  var controlTaskName: String = _

  @BeanProperty
  @Property(label = "Control task parameters", required = false, description = "Optional map of parameters to pass to the control task")
  var controlTaskParams: JMap[String, String] = new JHashMap[String, String]()
}

