package com.xebialabs.xlplatform.scheduler

import akka.actor.ActorSystem
import com.typesafe.config.Config
import com.xebialabs.xlplatform.config.{ConfigLoader, ConfigurationHolder}
import grizzled.slf4j.Logging

import scala.concurrent.duration._
import scala.concurrent.Await._
import scala.concurrent.ExecutionContext


object SchedulerActorSystem extends Logging {

  val actorSystem: ActorSystem = newActorSystem

  private[scheduler] def newActorSystem: ActorSystem = {
    logger.info("Starting the xl-scheduler actor system")
    val xlConfig: Config = ConfigLoader.loadWithDynamic(ConfigurationHolder.get())
    val actorConfig = xlConfig.getConfig("deploy.task.scheduler.system")
    ActorSystem.create("xl-scheduler-system", actorConfig)
  }

  lazy val scheduler = actorSystem.actorOf(Scheduler.props(), "scheduler")
  lazy val controlTaskExecutor = actorSystem.actorOf(ControlTaskExecutor.props(), "control-task-executor")

  def shutdownTheSystem() = {
    logger.info("Shutting down the xl-scheduler actor system...")
    result(actorSystem.terminate(), 20.seconds)
  }

  implicit lazy val dispatcher: ExecutionContext = actorSystem.dispatcher
}
