package com.xebialabs.xlplatform.scheduler.spring;

import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;

@Component
public class ServiceHolder {

    private static final AtomicReference<RepositoryService> repositoryService = new AtomicReference<>();
    private static final AtomicReference<TaskExecutionEngine> taskExecutionEngine = new AtomicReference<>();
    private static final AtomicReference<WorkDirFactory> workDirFactory = new AtomicReference<>();
    private static final AtomicReference<GarbageCollectionService> garbageCollectionService = new AtomicReference<>();


    @Autowired
    public ServiceHolder(RepositoryService repositoryService, WorkDirFactory workDirFactory, GarbageCollectionService garbageCollectionService) {
        ServiceHolder.repositoryService.set(repositoryService);
        ServiceHolder.workDirFactory.set(workDirFactory);
        ServiceHolder.garbageCollectionService.set(garbageCollectionService);
    }

    public static void setTaskExecutionEngine(TaskExecutionEngine engine) {
        ServiceHolder.taskExecutionEngine.set(engine);
    }

    public static RepositoryService getRepositoryService() {
        return ServiceHolder.repositoryService.get();
    }

    public static TaskExecutionEngine getTaskExecutionEngine() {
        return ServiceHolder.taskExecutionEngine.get();
    }

    public static WorkDirFactory getWorkDirFactory() {
        return ServiceHolder.workDirFactory.get();
    }


    public static GarbageCollectionService getGarabageCollectionService() {
        return garbageCollectionService.get();
    }
}
