package com.xebialabs.deployit.engine.tasker.repository

import org.apache.pekko.actor.ActorPath
import com.xebialabs.deployit.engine.api.execution._
import com.xebialabs.deployit.engine.tasker.{BlockPath, Description, TaskId, TaskSpecification}
import org.joda.time.DateTime

import java.util
import scala.beans.BeanProperty

trait CrudTaskRepository {

  def store(taskId: TaskId, description: String, owner: String, workerId: Integer, metadata: util.Map[String, String], taskSpecMaybe: Option[TaskSpecification] = None): Unit

  def task(taskId: TaskId, loadFullSpec: Boolean = false): Option[ActiveTask]

  def tasks(loadFullSpec: Boolean = false): List[ActiveTask]

  def delete(taskId: TaskId): Unit
}

trait ActiveTaskRepository extends CrudTaskRepository {

  def store(taskId: TaskId, spec: TaskSpecification, path: ActorPath): Unit

  def changeOwner(taskId: TaskId, newOwner: String): Unit

  def workerAddress(taskId: TaskId): Option[String]

  def ciPathsByDeployments(taskIds: List[TaskId]): Map[String, List[String]]

  def ciPathsByControlTasks(taskIds: List[TaskId]): Map[String, List[String]]

  def recordStartDate(taskID: TaskId): Unit

  def recordCompletionDate(taskID: TaskId): Unit

  def updateState(taskId: TaskId, state: String)
}

class ActiveTask(
                  @BeanProperty val id: TaskId,
                  @BeanProperty val description: Description,
                  @BeanProperty val owner: String,
                  @BeanProperty val metadata: util.Map[String, String],
                  @BeanProperty val workerId: Integer,
                  @BeanProperty val state: TaskExecutionState = null,
                  @BeanProperty val startDate: DateTime = null,
                  @BeanProperty val completionDate: DateTime = null,
                  @BeanProperty val spec: Option[TaskSpecification] = None
                ) extends TaskWithBlock with TaskState {

  override def getScheduledDate: DateTime = null

  override def getFailureCount: Int = 0

  override def getBlock: BlockState = spec.map(_.getBlock).orNull

  override def getPackageDependencies: util.List[TaskPackageDependency] = spec.map(_.getPackageDependencies).orNull

  override def getActiveBlocks: util.List[Description] = null

  override def getNrSteps: Int = fetchStepSeq.map(_.size).getOrElse(-1)

  override def getCurrentStepNr: Int = -1

  override def getCurrentStepNrs: util.List[Integer] = new util.ArrayList[Integer]()

  private[this] def fetchStepSeq: Option[IndexedSeq[((BlockPath, StepState), Int)]] = spec.map(_.getBlock.getStepsWithPaths().zipWithIndex.toIndexedSeq)
}

class WorkerInfo(@BeanProperty val id: Int, @BeanProperty val name: String)
