package com.xebialabs.deployit.engine.tasker

import com.xebialabs.deployit.engine.tasker.ActiveTasksCounterActor.Messages.ForwardMessage
import org.apache.pekko.actor.{ActorRef, ExtendedActorSystem, Extension, ExtensionId, ExtensionIdProvider}

object ActiveTasksQueue extends ExtensionId[ActiveTasksQueue] with ExtensionIdProvider {
  override def createExtension(system: ExtendedActorSystem): ActiveTasksQueue =
    new ActiveTasksQueue(system.actorOf(ActiveTasksCounterActor.props, "active-task-counter"))

  override def lookup(): ExtensionId[_ <: Extension] = ActiveTasksQueue
}

class ActiveTasksQueue(counterActor: ActorRef) extends Extension {
  def addToQueueOrForward(to: ActorRef, msg: AnyRef)(implicit sender: ActorRef): Unit = {
    counterActor ! ForwardMessage(to, msg)
  }
}
