package com.xebialabs.deployit.engine.tasker

import com.xebialabs.deployit.engine.tasker.ArchiveActor.messages.SendToArchive
import com.xebialabs.deployit.engine.tasker.MdcUtils._
import com.xebialabs.deployit.engine.tasker.StepExecutingActor.messages.ExecuteStep
import com.xebialabs.deployit.engine.tasker.TaskManagingActor.messages.Recovered
import com.xebialabs.deployit.engine.tasker.messages.TaskDone
import org.apache.pekko.actor.Actor
import org.apache.pekko.actor.Actor._

trait BecomeWithMdc {
  self: Actor =>
  val task: Task

  def becomeWithMdc(receive: Receive, discardOld: Boolean = true): Unit = context.become(ReceiveWithMdc(task)(receive), discardOld)

}

object ReceiveWithMdc {

  def apply(task: Task)(r: Receive): Receive = new ReceiveWithMdc(Some(task), Some(task.getId), r)

  def apply(taskId: TaskId)(r: Receive): Receive = new ReceiveWithMdc(None, Some(taskId), r)

  def apply()(r: Receive): Receive = new ReceiveWithMdc(None, None, r)

}

class ReceiveWithMdc(task: Option[Task], taskId: Option[TaskId], realReceive: Receive) extends Receive {

  def isDefinedAt(o: Any): Boolean = realReceive.isDefinedAt(o)

  def apply(message: Any): Unit = withMdc(mdcWithTaskAndMessage(message)) {
    realReceive(message)
  }

  private def mdcWithTaskAndMessage(message: Any): Map[String, TaskId] = {
    val extraMdc = task.map(mdcWithTask).getOrElse(Map()) ++
      taskId.map(taskId => {
        Map(TaskIdAttributeName -> taskId)
      }).getOrElse(Map()) ++ {
      message match {
        case ExecuteStep(s, _) => Map(StepDescriptionAttributeName -> s.getDescription)
        case Recovered(t) => mdcWithTask(t)
        case SendToArchive(t, _) => mdcWithTask(t)
        case TaskDone(t) => mdcWithTask(t)
        case _ => Map()
      }
    }
    extraMdc
  }
}

