package com.xebialabs.deployit.engine.tasker.repository

import com.xebialabs.deployit.core.events.TaskPathStatusEvent
import com.xebialabs.deployit.engine.api.dto.TaskPathStatus
import com.xebialabs.deployit.engine.tasker.TaskId

trait TaskPathStatusRepository {

  def batchCreate(taskPathStatuses: Seq[TaskPathStatusEvent], updateTime: Long): Unit

  def create(taskId: TaskId, path: String, status: String, updateTime: Long): Unit

  def delete(taskId: TaskId): Unit

  def findOne(taskId: TaskId, path: String): Option[TaskPathStatus]
}
