package com.xebialabs.deployit.engine.tasker

import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import org.apache.pekko.actor.{ActorContext, Props}

sealed trait SatelliteBlockRouter {

  def route(task: Task, block: ExecutableBlock, ctx: TaskExecutionContext)(implicit context: ActorContext): Props

}

object SatelliteBlockRouter {

  object Master extends SatelliteBlockRouter {

    def route(task: Task, block: ExecutableBlock, ctx: TaskExecutionContext)(implicit context: ActorContext): Props =
      routeToSatellite(task, block, ctx) getOrElse {
        block match {
          case cb: CompositeBlock => BlockExecutingActor.props(task, cb, ctx, Master)
          case sb: StepBlock => StepBlockExecutingActor.props(task, sb, ctx)
        }
      }

    private def routeToSatellite(task: Task, block: ExecutableBlock, ctx: TaskExecutionContext)
                                (implicit context: ActorContext): Option[Props] =
      block.satellite.map(sat => BlockOnSatellite.props(task, block, ActorLocator(sat), context.self))

  }

  object Satellite extends SatelliteBlockRouter {

    def route(task: Task, block: ExecutableBlock, ctx: TaskExecutionContext)(implicit context: ActorContext): Props =
      block match {
        case sb: StepBlock => StepBlockExecutingActor.props(task, sb, ctx)
        case cb: CompositeBlock => BlockExecutingActor.props(task, cb, ctx, Satellite)
      }
  }

}