package com.xebialabs.deployit.engine.tasker

import com.xebialabs.deployit.plugin.api.flow.Step
import org.slf4j.MDC

object MdcUtils {

  val TaskIdAttributeName = "taskId"
  val UsernameAttributeName = "username"
  val StepDescriptionAttributeName = "stepDescription"

  def withMdc[T](mdc: Map[String, String])(f: => T): T = {
    try {
      MDC.clear()
      mdc.foreach(kv => MDC.put(kv._1, kv._2))
      f
    } finally {
      MDC.clear()
    }
  }

  def mdcWithTask(task: Task) = Map(TaskIdAttributeName -> task.getId, UsernameAttributeName -> task.getOwner)

  def mdcWithStep(step: Step) = Map(StepDescriptionAttributeName -> step.getDescription)

}
