package com.xebialabs.deployit.engine.tasker.satellite

import org.apache.pekko.actor.ActorPath
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.engine.tasker.distribution.TasksManager

object Paths {
  val systemName = "XL-Satellite"

  val root: ActorPath = ActorPath.fromString(s"pekko://$systemName/user/")

  val tasks: ActorPath = root / "tasks"

  def log(taskId: TaskId): ActorPath = root / TasksManager.name / taskId / "log"
}
