package com.xebialabs.deployit.engine.tasker

import com.xebialabs.deployit.engine.tasker.Samurai.{Depart, deadRowTimeout}
import grizzled.slf4j.Logging
import org.apache.pekko.actor.{Actor, ActorContext, Cancellable, PoisonPill}

import scala.concurrent.duration.{FiniteDuration, _}

object Samurai {

  private val deadRowTimeout: FiniteDuration = 1.minute

  object Depart extends Serializable
}

trait Samurai extends Logging {

  def doNotAcceptMessages(logMessage: String = "")(implicit context: ActorContext): Unit = {
    debug(s"$logMessage - ignoring all messages from now on ${context.self}")
    context.become(`i'm dead`)
  }

  def harakiri(logMessage: String = "")(implicit context: ActorContext): Unit = {
    debug(s"$logMessage - harakiri on ${context.self}")
    context.become(`i'm dead`)
    context.self ! PoisonPill
  }

  private def `i'm dead`(implicit context: ActorContext): Actor.Receive = {
    case m: Any => context.system.deadLetters forward m
  }

  def deadRow(logMessage: String = "")(implicit context: ActorContext): Unit = {
    debug(s"$logMessage - dead row on ${context.self}")
    val cancellable = context.system.scheduler.scheduleOnce(deadRowTimeout, context.self, Depart)(context.dispatcher, context.self)
    context.become(waitingInDeadRow(logMessage, cancellable))
  }

  private def waitingInDeadRow(logMessage: String = "", cancellable: Cancellable)(implicit context: ActorContext): Actor.Receive = {
    case Depart =>
      cancellable.cancel()
      harakiri(logMessage)
    case m: Any => context.system.deadLetters forward m
  }
}
