package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.security.MessageDigest

import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider
import com.xebialabs.deployit.util.JavaCryptoUtils
import grizzled.slf4j.Logging

class TypeSafeItem(override val checksumAlgorithmProvider: ChecksumAlgorithmProvider, key: String, value: String)
  extends ConfigurationTreeItem with Logging {

  override def calculateConfigHash: String = {
    if (configHash == null) {
      val keyValue = key + ':' + value
      val hash: MessageDigest = checksumAlgorithmProvider.getMessageDigest
      hash.update(keyValue.getBytes("UTF-8"))
      configHash = JavaCryptoUtils.digest(hash)
      trace(s"Using hash $configHash for $keyValue")
    }
    configHash
  }

}
