package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.io.File

import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider
import grizzled.slf4j.Logging

object ConfigurationHasher extends Logging {

  def generateConfigurationHash(checksumAlgorithmProvider: ChecksumAlgorithmProvider, files: Seq[File]): String = {
    val configurationTree: ConfigurationTree = new ConfigurationTree(checksumAlgorithmProvider)
    files.foreach(file => {
      if(file.isDirectory) {
        trace(s"Adding directory ${file.getPath} ${file.getName}")
        configurationTree.addChild(new DirectoryItem(checksumAlgorithmProvider, file))
      }
      else {
        trace(s"Adding file ${file.getPath} ${file.getName}")
        configurationTree.addChild(new FileItem(checksumAlgorithmProvider, file))
      }
    })
    configurationTree.calculateConfigHash
  }

}
