package com.xebialabs.deployit.engine.tasker.step;

import java.util.concurrent.atomic.AtomicBoolean;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

public class PauseStep implements Step {
    private final AtomicBoolean paused = new AtomicBoolean(false);

    @Override
    public int getOrder() {
        return 50;
    }

    @Override
    public String getDescription() {
        return "Pause the execution";
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return paused.getAndSet(true) ? StepExitCode.SUCCESS : StepExitCode.PAUSE;
    }
}
