package com.xebialabs.deployit.engine.tasker

import com.xebialabs.deployit.core.events.DeploymentStateEvent
import com.xebialabs.deployit.event.EventBusHolder
import org.apache.pekko.actor.{Actor, Props}

class RemoteDeploymentStateEventListener extends Actor {

  override def receive: Receive = {
    case e: DeploymentStateEvent => EventBusHolder.publish(e)
  }
}

object RemoteDeploymentStateEventListener {
  val name = "remote-deployment-state-event-listener"

  def props(): Props = Props(new RemoteDeploymentStateEventListener)
}
