package com.xebialabs.deployit.engine

import akka.actor.{ActorContext, ActorRef, Props}

import scala.collection.mutable

package object tasker {
  type Cache[A, B] = collection.mutable.Map[A, B]
  val Cache: mutable.Map.type = collection.mutable.Map

  type TaskId = String
  type BlockId = String
  type Description = String
  type StepId = String
  val stateManagementDispatcher = "deploy.task.dispatchers.state-management-dispatcher"
  val stateEventListenerDispatcher = "deploy.task.dispatchers.state-event-listener-dispatcher"
  val stepDispatcher = "deploy.task.dispatchers.step-dispatcher"
  val archiveDispatcher = "deploy.task.dispatchers.archive-dispatcher"

  trait ActorCreationSupport {
    def createChild(props: Props, name: String): ActorRef
  }

  trait ActorContextCreationSupport extends ActorCreationSupport {
    def context: ActorContext

    def createChild(props: Props, name: String): ActorRef = context.actorOf(props, name)

    def createChild(props: Props): ActorRef = context.actorOf(props)
  }

}
