package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;

import static java.lang.String.format;

@HttpResponseCodeResult(statusCode = 404)
public class TaskNotFoundException extends DeployitException {
    public TaskNotFoundException(final String location, final String id) {
        super(format("The task with id [%s] could not be found in the %s", id, location));
    }
}
