package com.xebialabs.deployit.engine.tasker.repository

import com.xebialabs.deployit.core.events.TaskStepLogEvent
import com.xebialabs.deployit.engine.api.dto.TaskStepLog
import com.xebialabs.deployit.engine.tasker.TaskId

trait TaskStepLogRepository {

  def batchCreate(taskStepLogs: Seq[TaskStepLogEvent], updateTime: Long): Unit

  def create(taskStepLog: TaskStepLogEvent, updateTime: Long): Unit

  def findOne(taskId: TaskId, stepPath: String): Option[TaskStepLog]

  def delete(taskId: TaskId): Unit

  def findAll(taskId: TaskId): List[TaskStepLog]

}
