package com.xebialabs.deployit.engine.tasker

import akka.actor.Actor
import grizzled.slf4j.Logging
import org.apache.commons.lang.exception.ExceptionUtils

trait ActorLifecycleLogging extends Actor with Logging {

  override def aroundPreStart(): Unit = {
    logger.debug(s"pre-start is being called on ${self.path}")
    super.aroundPreStart()
  }

  override def aroundPreRestart(reason: Throwable, message: Option[Any]): Unit = {
    logger.error(s"pre-restart is being called on ${self.path} due to $reason, ${ExceptionUtils.getStackTrace(reason)}")
    super.aroundPreRestart(reason, message)
  }

  override def aroundPostRestart(reason: Throwable): Unit = {
    logger.error(s"post-restart is being called on ${self.path} due to $reason, ${ExceptionUtils.getStackTrace(reason)}")
    super.aroundPostRestart(reason)
  }

  override def aroundPostStop(): Unit = {
    logger.debug(s"post-stop is being called on ${self.path}")
    super.aroundPostStop()
  }

  override def unhandled(message: Any): Unit = {
    logger.info(s"unhandled $message for ${self.path}")
    super.unhandled(message)
  }

}
