package com.xebialabs.deployit.engine.tasker

import akka.actor.{Actor, ActorRef, Props}
import com.xebialabs.deployit.engine.tasker.ArchiveActor.messages.SendToArchive
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever
import com.xebialabs.deployit.engine.tasker.messages.{Archived, FailedToArchive}

import scala.util.{Failure, Success, Try}
import grizzled.slf4j.Logging

object ArchiveActor {
  val name = "archive"
  def props(service: Archive, stepLogRetriever: StepLogRetriever): Props = Props(new ArchiveActor(service, stepLogRetriever)).withDispatcher(archiveDispatcher)

  object messages {
    case class SendToArchive(task: Task, notificationActor: ActorRef)
  }

}

class ArchiveActor(service: Archive, stepLogRetriever: StepLogRetriever) extends Actor with Logging {

  def receive: Actor.Receive = ReceiveWithMdc() {
    case SendToArchive(task, notificationActor: ActorRef) =>
      info(s"Received [Archive] message with task [${task.getId}].")
      stepLogRetriever.fillLogs(task)
      Try(service.archive(task)) match {
        case Success(_) =>
          notificationActor ! Archived(task.getId)
          stepLogRetriever.removeLogs(task.getId)
        case Failure(ex) =>
          notificationActor ! FailedToArchive(task.getId, ex)
      }
    case m@_ => error(s"I don't understand message [$m]")
  }
}
