package com.xebialabs.deployit.engine.tasker.websockets

import akka.actor.{Actor, Props}
import com.xebialabs.deployit.core.events.ChangeSetEvent
import com.xebialabs.deployit.event.EventBusHolder

class RemoteChangeSetEventListener extends Actor {

  override def receive: Receive = {
    case e: ChangeSetEvent => EventBusHolder.publish(e)
  }
}

object RemoteChangeSetEventListener {
  val name = "remote-changesetevent-listener"
  def props(): Props = Props(new RemoteChangeSetEventListener)
}
