package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.io.File

import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider
import grizzled.slf4j.Logging

class DirectoryItem(override val checksumAlgorithmProvider: ChecksumAlgorithmProvider, directory: File)
  extends ParentItem with Logging {

  directory.listFiles().foreach(file => {
    if(file.isDirectory) {
      trace(s"Adding directory ${file.getPath} ${file.getName}")
      addChild(new DirectoryItem(checksumAlgorithmProvider, file))
    }
    else {
      trace(s"Adding file ${file.getPath} ${file.getName}")
      addChild(new FileItem(checksumAlgorithmProvider, file))
    }
  })

}
