package com.xebialabs.deployit.engine.tasker.satellite

import java.io.File

import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.io.Input
import com.esotericsoftware.kryo.serializers.FieldSerializer
import com.xebialabs.deployit.repository.WorkDir

class WorkDirSerializer(kryo: Kryo, baseWorkDir: File, create: Boolean = false) extends FieldSerializer[WorkDir](kryo, classOf[WorkDir]) {

  override def read(kryo: Kryo, input: Input, `type`: Class[WorkDir]): WorkDir = {
    val workDir = super.read(kryo, input, `type`)
    workDir.rebase(baseWorkDir, create)
  }
}
