package com.xebialabs.deployit.engine.tasker.repository

import akka.actor.ActorPath
import com.xebialabs.deployit.engine.api.execution._
import com.xebialabs.deployit.engine.tasker.{Description, TaskId, TaskSpecification}
import org.joda.time.DateTime

import java.util
import scala.beans.BeanProperty

trait CrudTaskRepository {

  def store(taskId: TaskId, description: String, owner: String, workerId: Integer, metadata: util.Map[String, String]): Unit

  def task(taskId: TaskId): Option[ActiveTask]

  def tasks(): List[ActiveTask]

  def delete(taskId: TaskId): Unit

}

trait ActiveTaskRepository extends CrudTaskRepository {

  def store(taskId: TaskId, spec: TaskSpecification, path: ActorPath): Unit

  def changeOwner(taskId: TaskId, newOwner: String): Unit

  def workerAddress(taskId: TaskId): Option[String]

  def ciPathsByDeployments(taskIds: List[TaskId]): Map[String, List[String]]

  def ciPathsByControlTasks(taskIds: List[TaskId]): Map[String, List[String]]

}

class ActiveTask(
                  @BeanProperty val id: TaskId,
                  @BeanProperty val description: Description,
                  @BeanProperty val owner: String,
                  @BeanProperty val metadata: util.Map[String, String],
                  @BeanProperty val workerId: Integer
                ) extends TaskWithBlock with TaskState {

  override def getBlock: BlockState = null

  override def getActiveBlocks: util.List[TaskId] = null

  override def getState: TaskExecutionState = null

  override def getScheduledDate: DateTime = null

  override def getStartDate: DateTime = null

  override def getCompletionDate: DateTime = null

  override def getFailureCount: Int = 0

  override def getPackageDependencies: util.List[TaskPackageDependency] = null

  override def getNrSteps: Int = -1

  /**
    * @deprecated Use { @link #getCurrentStepNrs()} instead.
    */
  override def getCurrentStepNr: Int = -1

  override def getCurrentStepNrs: util.List[Integer] = new util.ArrayList[Integer]()
}

class WorkerInfo(@BeanProperty val id: Int, @BeanProperty val name: String)
