package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.io.{BufferedInputStream, File, FileInputStream, InputStream}
import java.security.MessageDigest

import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider
import com.xebialabs.deployit.util.JavaCryptoUtils
import grizzled.slf4j.Logging

class FileItem(override val checksumAlgorithmProvider: ChecksumAlgorithmProvider, file: File)
  extends ConfigurationTreeItem with Logging {

  var BUFFER_SIZE: Int = 512

  override def calculateConfigHash: String = {
    if (configHash == null) {
      val hash: MessageDigest = checksumAlgorithmProvider.getMessageDigest
      hash.update(file.getName.getBytes("UTF-8"))
      if (file.exists()) {
        updateDigest(hash, new BufferedInputStream(new FileInputStream(file)))
      }
      configHash = JavaCryptoUtils.digest(hash)
      trace(s"Using hash $configHash for ${file.getName}")
    }
    configHash
  }

  def updateDigest(digest: MessageDigest, data: InputStream): MessageDigest = {
    val buffer = new Array[Byte](BUFFER_SIZE)
    var read = data.read(buffer, 0, BUFFER_SIZE)
    while (read > -1) {
      digest.update(buffer, 0, read)
      read = data.read(buffer, 0, BUFFER_SIZE)
    }
    digest
  }

}
