package com.xebialabs.deployit.engine.tasker.satellite

import akka.actor.ExtendedActorSystem
import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.serializers.FieldSerializer
import com.esotericsoftware.kryo.serializers.FieldSerializer.CachedField
import com.xebialabs.deployit.engine.tasker.TaskStep

import scala.util.Try

class TaskStepSerializer(kryo: Kryo) extends FieldSerializer[TaskStepSerializer](kryo, classOf[TaskStep]) {
  override def initializeCachedFields(): Unit = {
    getFields.find(_.getField.getName == "implementation").foreach(removedFields.add)
  }

  override def removeField(fieldName: String): Unit = Try(super.removeField(fieldName))

  override def removeField(removeField: CachedField[_]): Unit = Try(super.removeField(removeField))
}

object TaskStepSerializer {
  private[satellite] def kryo(system: ExtendedActorSystem) = {
    val kryo = KryoSerializer.getMagicCombination(system)
    kryo.register(classOf[TaskStep], new TaskStepSerializer(kryo))
    kryo
  }

}
