package com.xebialabs.deployit.spring

import org.springframework.beans.factory.BeanCurrentlyInCreationException
import org.springframework.stereotype.Component

import java.util.concurrent.atomic.AtomicReference

@Component
class BeanWrapper[A] {

  val instance = new AtomicReference[A]

  def get(): A = {
    if(instance.get() == null) {
      throw new BeanCurrentlyInCreationException("BeanWrapper is not created yet.")
    }
    instance.get()
  }
  def set(a: A): Unit = {
    instance.set(a)
  }
}

object BeanWrapper {

  def apply[A]() = new BeanWrapper[A]()

  def apply[A](value: A): BeanWrapper[A] = {
    val wrapper = new BeanWrapper[A]()
    wrapper.set(value)
    wrapper
  }
}