package io.altoo.akka.serialization.kryo

import akka.actor.ExtendedActorSystem
import akka.event.LoggingAdapter
import com.esotericsoftware.kryo.Kryo
import com.xebialabs.deployit.engine.tasker.satellite.KryoSerializer

class KryoAkkaSerializer(system: ExtendedActorSystem) extends KryoSerializer(system) {
  private val serializerPoolOnSuper = this.getClass.getSuperclass.getDeclaredField("serializerPool")
  serializerPoolOnSuper.setAccessible(true)

  private val queueBuilderClassOnSuper = this.getClass.getSuperclass.getDeclaredField("queueBuilderClass")
  queueBuilderClassOnSuper.setAccessible(true)
  private val queueBuilderClass = queueBuilderClassOnSuper.get(this).asInstanceOf[Class[_]]

  private val settingsOnSuper = this.getClass.getSuperclass.getDeclaredField("settings")
  settingsOnSuper.setAccessible(true)
  private val settings = settingsOnSuper.get(this).asInstanceOf[KryoSerializationSettings]

  private val logOnSuper = this.getClass.getSuperclass.getDeclaredField("log")
  logOnSuper.setAccessible(true)
  private val log = logOnSuper.get(this).asInstanceOf[LoggingAdapter]

  private val pool = new SerializerPool(
    queueBuilderClass.getDeclaredConstructor().newInstance().asInstanceOf[DefaultQueueBuilder],
    () => new KryoSerializerBackend(
      getCustomKryo,
      settings.bufferSize,
      settings.maxBufferSize,
      settings.useManifests,
      settings.useUnsafe
    )(log)
  )

  serializerPoolOnSuper.set(this, pool)

  var kryoCustomizers: Seq[KryoCustomizer] = Seq()

  def setKryoCustomizers(kryoCustomizer: KryoCustomizer*): Unit = {
    kryoCustomizers = kryoCustomizer
  }

  private def getCustomKryo: Kryo = {
    val kryo = KryoSerializer.getMagicCombination(system)
    kryoCustomizers.foreach(_.customize(kryo))
    kryo
  }
}

trait KryoCustomizer {
  def customize(kryo: Kryo): Unit
}
