package com.xebialabs.deployit.engine.tasker.satellite

import akka.actor.ActorPath
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.engine.tasker.distribution.TasksManager

object Paths {
  val systemName = "XL-Satellite"

  val root: ActorPath = ActorPath.fromString(s"akka://$systemName/user/")

  val tasks: ActorPath = root / "tasks"

  def log(taskId: TaskId): ActorPath = root / TasksManager.name / taskId / "log"
}
