package com.xebialabs.deployit.engine.tasker.repository

import com.xebialabs.deployit.engine.api.dto.TaskPathStatus
import com.xebialabs.deployit.engine.tasker.TaskId

trait TaskPathStatusRepository {

  def createOrUpdate(taskId: TaskId, path: String, status: String, updateTime: Long): Unit

  def findOne(taskId: TaskId, path: String): Option[TaskPathStatus]

  def delete(taskId: TaskId): Unit

  def findAll(taskId: TaskId): List[TaskPathStatus]

  def findUpdateTime(taskId: TaskId, path: String): Option[(String, Long)]
}
