package com.xebialabs.deployit.engine.tasker.repository

import com.xebialabs.deployit.engine.api.dto.ActiveTaskStatus
import com.xebialabs.deployit.engine.tasker.TaskId

trait ActiveTaskStatusRepository {

  def create(taskId: TaskId, path: String, status: String): Unit

  def findOne(taskId: TaskId, path: String): Option[ActiveTaskStatus]

  def delete(taskId: TaskId): Unit

  def update(taskId: TaskId, path: String, status: String): Unit

  def findAll(taskId: TaskId): List[ActiveTaskStatus]
}
